'From Squeak3.5 of ''11 April 2003'' [latest update: #5180] on 10 February 2004 at 12:50:34 pm'!
Morph subclass: #BowlingScoreMorph
	instanceVariableNames: 'score frameMorph fw fh textColor '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'My Stuff'!

!BowlingScoreMorph methodsFor: 'initialization' stamp: 'DY 2/7/2004 17:16'!
allocateFrames: basePoint
	| bp |
	bp := basePoint.
	frameMorph _ Array new: 10.
	1
		to: 9
		do: [:i | 
			frameMorph
				at: i
				put: (BowlingFrameMorph new: 2 at: bp).
			bp _ bp + ((frameMorph at: i) width - 1 @ 0)].
	frameMorph
		at: 10
		put: (BowlingFrameMorph new: 3 at: bp).
! !

!BowlingScoreMorph methodsFor: 'initialization' stamp: 'DY 2/7/2004 17:15'!
initialize: bowler 
	| basePoint |
	super initialize.
	textColor := Color black.
	fw _ BowlingFrameMorph width.
	fh _ BowlingFrameMorph height.
	self bounds: (Rectangle left: fw right: 14*fw top: fw bottom: fh+fw).
	basePoint _ (self bounds left + (3*fw) + 9) @ self bounds top.
	score _ BowlingScore new initialize: bowler.
	self allocateFrames: basePoint
! !


!BowlingScoreMorph methodsFor: 'player commands' stamp: 'DY 2/4/2004 20:22'!
putBall: pinCount 
	| frame ball lastFrameScored |
	frame _ score frame.
	ball _ score ball.
	lastFrameScored _ score lastFrameScored.
	(score putBall: pinCount)
		ifTrue: [(frameMorph at: frame)
				setPinCount: ball
				to: pinCount.
			self changed.
			score lastFrameScored ~~ lastFrameScored
				ifTrue: [
					lastFrameScored + 1 to: score lastFrameScored do: [ :i |
						(frameMorph at: i)	setScore: (score scoreInFrame: i)
					]
				].
			^ true].
	^ false! !

!BowlingScoreMorph methodsFor: 'player commands' stamp: 'DY 2/9/2004 15:45'!
putSpare
	| frame ball |
	frame := score frame.
	ball := score ball.
	frame < 10 & (ball ~~ 2) ifTrue: [ ^false ].
	frame < 10 & (ball == 2) & ((score pinsAt: frame at: 1) = 10) ifTrue: [ ^false ].
	(ball = 2) & ((score pinsAt: frame at: 1) ~~ 10) ifTrue: [ ^ self putBall: 10 - (score pinsAt: frame at: 1) ].
	frame = 10 & (ball = 3) & (( score pinsAt: 10 at: 1) == 10) & ((score pinsAt: 10 at: 2) ~~ 10) ifTrue: [
		^ self putBall: 10 - (score pinsAt: frame at: 2) ].
	^false! !


!BowlingScoreMorph methodsFor: 'drawing' stamp: 'DY 2/4/2004 11:22'!
displayOnTranscript
^score displayScore! !

!BowlingScoreMorph methodsFor: 'drawing' stamp: 'DY 2/7/2004 16:26'!
drawOn: aCanvas 
	aCanvas fillRectangle: self bounds color: Color white.
	aCanvas frameRectangle: self bounds color: Color black.
	self positionFrames.
	1
		to: 10
		do: [:i | (frameMorph at: i)
				drawOn: aCanvas].
	aCanvas drawString: score bowlerName 
			at: self left + 10 @ (self bottom - 20)
			font: nil color: textColor! !


!BowlingScoreMorph methodsFor: 'private' stamp: 'DY 2/4/2004 20:42'!
positionFrames
	| basePoint |
	basePoint _ (self bounds left + (3*BowlingFrameMorph width) + 9) @ self bounds top.
	1
		to: 10
		do: [:i | 
			(frameMorph at: i) 
				moveTo: basePoint.
			basePoint _ basePoint + ((frameMorph at: i) width - 1 @ 0)].
! !


!BowlingScoreMorph methodsFor: 'event handling' stamp: 'DY 2/9/2004 18:52'!
handleBackSpace
	| name pcl |
	pcl _ score getPinCountList.
	name _ score bowlerName.
	score _ BowlingScore new initialize: name.
	self allocateFrames: 0 @ 0.
	self positionFrames.
	pcl size ~~ 0
		ifTrue: [pcl removeLast].
	[pcl size ~~ 0]
		whileTrue: [self putBall: pcl removeFirst].
	self changed! !

!BowlingScoreMorph methodsFor: 'event handling' stamp: 'DY 2/9/2004 18:56'!
handlesKeyboard: evt
	^true! !

!BowlingScoreMorph methodsFor: 'event handling' stamp: 'DY 2/7/2004 16:14'!
handlesMouseDown: evt
	^true! !

!BowlingScoreMorph methodsFor: 'event handling' stamp: 'DY 2/9/2004 18:53'!
keyStroke: evt
	"React to user's keystroke.  If a digit, then store it at the currently relevant pin position.  If a 
	 backspace, then take back the last pin count.  If an x, score a strike.  If a slash, score a spare."

	| char |
	textColor = Color red ifTrue: [
		char _ evt keyCharacter.
		(char < $0) not & (char > $9) not ifTrue: [
			| pincount |
			pincount _ (char asInteger - $0 asInteger).
			self putBall: pincount
		].
		char = 8 asCharacter ifTrue: [ self handleBackSpace ].
		char = $x | (char = $X) ifTrue: [ self putBall: 10 ].
		char = $/ ifTrue: [ self putSpare ]
	]	
! !

!BowlingScoreMorph methodsFor: 'event handling' stamp: 'DY 2/7/2004 16:33'!
mouseDown: evt 
	textColor = Color black
		ifTrue: [textColor _ Color red.
			evt hand newKeyboardFocus: self]
		ifFalse: [textColor _ Color black.
			evt hand newKeyboardFocus: nil].
	self changed! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

BowlingScoreMorph class
	instanceVariableNames: ''!

!BowlingScoreMorph class methodsFor: 'instance creation' stamp: 'DY 2/4/2004 11:15'!
new: bowler
^super new initialize: bowler! !
